/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connserv;

import com.ibm.hwmca.fw.connserv.CommPathManager;
import com.ibm.hwmca.fw.connserv.ConnServException;
import com.ibm.hwmca.fw.connserv.PathCanceledException;
import com.ibm.hwmca.fw.connserv.PathCancellationListener;
import com.ibm.hwmca.fw.connserv.PathRequestInfo;
import com.ibm.hwmca.fw.connserv.UnableToFulfillException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.lang.ref.WeakReference;

public abstract class CommPath {
    public static final int STATE_NEW = 0;
    public static final int STATE_QUEUED = 1;
    public static final int STATE_AVAILABLE = 2;
    public static final int STATE_OPENING = 3;
    public static final int STATE_OPENED = 4;
    public static final int STATE_CLOSING = 5;
    public static final int STATE_CLOSED = 6;
    public static final int STATE_CANCELING = 7;
    public static final int STATE_CANCELED = 8;
    public static final int STATE_FAILED = 9;
    private static final String[] stateNames = new String[]{"New", "Queued", "Available", "Opening", "Opened", "Closing", "Closed", "Canceling", "Canceled", "Failed"};
    public static final int PRIORITY_LOW = 0;
    public static final int PRIORITY_MEDIUM = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int NOT_CANCELED = 0;
    public static final int CANCELED_BY_USER = 1;
    public static final int CANCELED_COMM_ERROR = 2;
    public static final int CANCELED_SHUTDOWN = 3;
    public static final int CANCELED_BY_APPLICATION = 4;
    private static final String TRACE_T = "XRCSCPHT";
    private static final String TRACE_F = "XRCSCPHF";
    private static int nextAvailableId = 0;
    private static CommPathManager cpm = CommPathManager.getCommPathManager();
    private int state = 0;
    private int priority;
    private int id;
    private PathRequestInfo requestInfo;
    private PathCancellationListener listener;
    private int cancellationReason = 0;
    private int stateAtTimeOfCloseOrCancel = 0;
    private WeakReference selfRef = new WeakReference<CommPath>(this);

    private static void trace(String msg) {
        Trace.trace(TRACE_T, msg);
    }

    private static void fdbg(String msg) {
        Trace.trace(TRACE_F, msg);
    }

    private static synchronized int allocateId() {
        return nextAvailableId++;
    }

    public CommPath(int priority, PathRequestInfo requestInfo) throws IllegalArgumentException {
        String excMsg = null;
        if (requestInfo == null) {
            excMsg = "RequestInfo parameter is null";
        } else if (priority < 0 || priority > 2) {
            excMsg = "Priority parameter is out of range";
        }
        if (excMsg != null) {
            Trace.trace(TRACE_T, "<> EXC: CommPath ctor called with invalid arguments.");
            throw new IllegalArgumentException(excMsg);
        }
        this.requestInfo = requestInfo;
        this.priority = priority;
        this.id = CommPath.allocateId();
        Trace.trace(TRACE_T, "<> CommPath ctor created path #" + this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAvailability() throws UnableToFulfillException, PathCanceledException, IllegalStateException {
        CommPath.trace("-> waitForAvailability() for path #" + this.id);
        CommPath commPath = this;
        synchronized (commPath) {
            if (this.hasBeenCanceled()) {
                CommPath.trace("<- waitForAvailability() EXC: Path is already canceled");
                throw new PathCanceledException("The path was canceled");
            }
            if (this.getState() != 0) {
                CommPath.trace("<- waitForAvailability() EXC: Path state is wrong");
                throw new IllegalStateException("CommPath is not in the 'new' state");
            }
            if (!cpm.isRCSOutboundEnabled()) {
                CommPath.trace("<- waitForAvailability() EXC: RCS Outbound support is disabled");
                throw new UnableToFulfillException("RCS Outbound support is disabled.");
            }
            this.moveToState(1);
        }
        try {
            CommPath.fdbg("Calling subclass's allocate resources() to line up resources");
            this.allocateResources();
        }
        catch (ConnServException e) {
            if (this.hasBeenCanceled()) {
                CommPath.trace("<- waitForAvailability() EXC: Path was canceled while in subclass");
                throw new PathCanceledException("The path was canceled");
            }
            this.moveToState(9);
            CommPath.trace("<- waitForAvailability() EXC: Subclass failed to get resources");
            throw new UnableToFulfillException(e);
        }
        catch (RuntimeException e) {
            this.moveToState(9);
            CommPath.trace("<- waitForAvailability() EXC: Subclass blew up, rethrowing its exc");
            throw e;
        }
        if (this.hasBeenCanceled()) {
            CommPath.fdbg("Hmm, path is now canceled.  Cleaning up.");
            try {
                this.freeResources();
            }
            catch (ConnServException e) {
                CommPath.fdbg("Swallowing exc thrown during cleanup:");
                Trace.trace(TRACE_F, e);
            }
            CommPath.trace("<- waitForAvailability() EXC: Path is now canceled");
            throw new PathCanceledException("The path was canceled");
        }
        this.moveToState(2);
        CommPath.trace("<- waitForAvailability() Ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException, PathCanceledException, IllegalStateException, UnableToFulfillException {
        CommPath.trace("-> open() for path #" + this.id);
        if (this.getState() == 0) {
            this.waitForAvailability();
        }
        CommPath commPath = this;
        synchronized (commPath) {
            if (this.hasBeenCanceled()) {
                CommPath.trace("<- open() EXC: Path was canceled");
                throw new PathCanceledException("The path was canceled");
            }
            if (this.getState() != 2) {
                CommPath.trace("<- open() EXC: Path state is wrong");
                throw new IllegalStateException("CommPath is not in the 'available' state");
            }
            this.moveToState(3);
        }
        try {
            CommPath.fdbg("Calling subclass's establishLink() to set up comm link");
            this.establishLink();
        }
        catch (ConnServException e) {
            if (this.hasBeenCanceled()) {
                CommPath.fdbg("Path canceled while in subclass, cleaning up");
                try {
                    this.freeResources();
                }
                catch (ConnServException ee) {
                    CommPath.fdbg("Swallowing exc thrown during cleanup:");
                    Trace.trace(TRACE_F, e);
                }
                CommPath.trace("<- open() EXC: Path was canceled while opening");
                throw new PathCanceledException("The path was canceled");
            }
            this.moveToState(9);
            CommPath.trace("<- open() EXC: Unable to get a connection");
            throw new UnableToFulfillException(e);
        }
        catch (RuntimeException e) {
            CommPath.fdbg("Subclass blew up, trying to clean up");
            try {
                this.freeResources();
            }
            catch (ConnServException ee) {
                CommPath.fdbg("Swallowing exc thrown during cleanup:");
                Trace.trace(TRACE_F, e);
            }
            this.moveToState(9);
            CommPath.trace("<- open() EXC: Subclass blew up, rethrowing its exc");
            throw e;
        }
        if (this.hasBeenCanceled()) {
            CommPath.fdbg("Hmm, path is now canceled.  Cleaning up.");
            try {
                this.terminateLink();
                this.freeResources();
            }
            catch (ConnServException e) {
                CommPath.fdbg("Swallowing exc thrown during cleanup:");
                Trace.trace(TRACE_F, e);
            }
            CommPath.trace("<- open() EXC: Path is now canceled");
            throw new PathCanceledException("The path was canceled");
        }
        this.moveToState(4);
        CommPath.trace("<- open() Ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int reason) {
        CommPath commPath = this;
        synchronized (commPath) {
            int st = this.getState();
            if (this.hasBeenClosed() || this.hasBeenCanceled()) {
                return;
            }
            if (st != 1 && st != 2 && st != 3 && st != 4) {
                throw new IllegalStateException("CommPath is not in a waiting or active state");
            }
            this.cancellationReason = reason;
            this.moveToState(7);
        }
        this.moveToState(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CommPath.trace("-> close() for path #" + this.id);
        CommPath commPath = this;
        synchronized (commPath) {
            if (this.hasBeenCanceled()) {
                CommPath.trace("<- close() Nop,  path is canceling/canceled ");
                return;
            }
            int st = this.getState();
            if (st != 2 && st != 4) {
                CommPath.trace("<- close() EXC: Path state is wrong");
                throw new IllegalStateException("CommPath is not in the available pr opened state");
            }
            this.moveToState(5);
        }
        try {
            CommPath.fdbg("Calling subclass to close connection and free resources");
            this.terminateLink();
            this.freeResources();
        }
        catch (Exception e) {
            CommPath.fdbg("Swallowing exc thrown during cleanup:");
            Trace.trace(TRACE_F, e);
        }
        this.moveToState(6);
        CommPath.trace("<- close() Ok");
    }

    public void addCancellationListener(PathCancellationListener listener) throws IllegalArgumentException {
    }

    public void removeCancellationListener() {
    }

    public synchronized int getPriority() {
        return this.priority;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized String getStateName() {
        return CommPath.getStateName(this.state);
    }

    private static String getStateName(int st) {
        return st >= 0 && st < stateNames.length ? stateNames[st] : "Unknown";
    }

    public int getId() {
        return this.id;
    }

    public PathRequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public synchronized int getCancellationReason() {
        return this.cancellationReason;
    }

    public boolean isCanceled() {
        return this.hasBeenCanceled();
    }

    public synchronized boolean hasBeenCanceled() {
        return this.state == 7 || this.state == 8;
    }

    private synchronized boolean hasBeenClosed() {
        return this.state == 5 || this.state == 6;
    }

    private synchronized boolean hasBeenClosedOrCanceled() {
        return this.state == 5 || this.state == 6 || this.state == 7 || this.state == 8;
    }

    public synchronized boolean isWaiting() {
        return CommPath.isWaiting(this.state);
    }

    private static boolean isWaiting(int st) {
        return st == 1 || st == 2;
    }

    public synchronized boolean isActive() {
        return CommPath.isActive(this.state);
    }

    private static boolean isActive(int st) {
        return st == 3 || st == 4 || st == 5 || st == 7;
    }

    private static boolean isTerminating(int st) {
        return st == 5 || st == 7;
    }

    private static boolean isTerminated(int st) {
        return st == 6 || st == 8;
    }

    synchronized WeakReference getRef() {
        return this.selfRef;
    }

    protected abstract void allocateResources() throws ConnServException;

    protected abstract void freeResources() throws ConnServException;

    protected abstract void cancelAllocateResources() throws ConnServException;

    protected abstract void establishLink() throws ConnServException;

    protected abstract void terminateLink() throws ConnServException;

    protected abstract void cancelEstablishLink() throws ConnServException;

    private synchronized void moveToState(int newState) {
        String meth = " moveToState(#" + this.id + ") ";
        CommPath.trace("->" + meth + "Moving path from " + CommPath.getStateName(this.state) + " state to " + CommPath.getStateName(newState) + " state");
        if (!CommPath.isTerminating(newState)) {
            if (CommPath.isWaiting(newState)) {
                if (!this.isWaiting()) {
                    cpm.addToWaitingQueue(this);
                }
            } else if (CommPath.isActive(newState)) {
                if (this.isWaiting()) {
                    cpm.moveFromWaitingToActiveQueue(this);
                }
            } else if (newState == 9) {
                if (this.isWaiting()) {
                    cpm.removeFromWaitingQueue(this);
                } else {
                    cpm.removeFromActiveQueue(this);
                }
            } else if (CommPath.isTerminated(newState)) {
                if (CommPath.isWaiting(this.stateAtTimeOfCloseOrCancel)) {
                    cpm.removeFromWaitingQueue(this);
                } else {
                    cpm.removeFromActiveQueue(this);
                }
            }
        }
        if (CommPath.isTerminating(newState)) {
            this.stateAtTimeOfCloseOrCancel = this.state;
        }
        this.state = newState;
        CommPath.trace("<-" + meth + "Ok, path now in " + CommPath.getStateName(this.state) + " state");
    }

    protected void finalize() throws Throwable {
        String meth = " CommPath:finalize(#" + this.id + ") ";
        int st = this.getState();
        if (st == 6 || st == 8 || st == 9) {
            CommPath.trace("<>" + meth + "No Op, path already closed/canceled/failed");
            return;
        }
        if (st == 0) {
            CommPath.trace("<>" + meth + "No Op, path was never used (still new state)");
            return;
        }
        if (st == 1 || st == 3 || st == 5 || st == 7) {
            CommPath.trace("<>" + meth + "Hmm, path is in an in-progress state (" + CommPath.getStateName(st) + ")?!?");
            return;
        }
        this.close();
        CommPath.trace("<>" + meth + "Path was in " + CommPath.getStateName(st) + " state, now closed");
    }
}

